package org.msh.tb.bd.tbforms.dhis2;

import org.msh.tb.entities.enums.Gender;

/**
 * Created by Mauricio on 20/03/2017.
 * Catefory option Combo Id used by many DHIS2 dataElements
 */
public enum SexCategoryOptionCombo {
    MALE("L6H0YWURtl8"),
    FEMALE("I8fdnDB4f9D");

    private String cocId;

    SexCategoryOptionCombo(String cocId) {
        this.cocId = cocId;
    }

    public String getCocId() {
        return cocId;
    }

    public static String findCocId(Gender gender) {
        if (Gender.MALE.equals(gender)) {
            return MALE.getCocId();
        }

        if (Gender.FEMALE.equals(gender)) {
            return FEMALE.getCocId();
        }

        throw new RuntimeException("SexCategoryOptionCombo: gender " + gender + "not Found");
    }
}
